@echo off
setlocal EnableDelayedExpansion

set OUTDIR=flac51_out
if not exist "%OUTDIR%" mkdir "%OUTDIR%"

for %%F in (*.aac *.ac3) do (
    echo ==============================
    echo Datei: %%F

    set CH=
    set LAYOUT=

    for /f "delims=" %%C in ('
        ffprobe -v error -select_streams a:0 -show_entries stream^=channels -of default^=noprint_wrappers^=1:nokey^=1 "%%F"
    ') do set CH=%%C

    for /f "delims=" %%L in ('
        ffprobe -v error -select_streams a:0 -show_entries stream^=channel_layout -of default^=noprint_wrappers^=1:nokey^=1 "%%F"
    ') do set LAYOUT=%%L

    echo Kanaele: !CH!
    echo Layout: !LAYOUT!

    if "!CH!"=="2" (
        echo Stereo erkannt
        ffmpeg -y -i "%%F" -c:a libvorbis -q:a 8 "%OUTDIR%\%%~nF.ogg"
    ) else if "!LAYOUT!"=="5.1(side)" (
        echo 5.1 side erkannt, remap
        ffmpeg -y -i "%%F" ^
            -filter_complex "channelmap=FL|FR|FC|LFE|SL|SR:channel_layout=5.1" ^
        -c:a flac -sample_fmt s16 ^
        "%OUTDIR%\%%~nF.flac"
		
    ) else if "!LAYOUT!"=="5.1" (
        echo 5.1 rear erkannt
        ffmpeg -y -i "%%F" -c:a flac -sample_fmt s16 ^
        "%OUTDIR%\%%~nF.flac"
    ) else (
        echo Unbekanntes Layout - uebersprungen
    )
)

echo Fertig
pause
